﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using System.Collections.Generic;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    /// <summary>
    /// Spawn some Pogobots
    /// </summary>
    class SpawnerPogobot : EnemyEntity
    {
        /// <summary>
        /// Number of Pgobots the spawner can handle
        /// </summary>
        int _iCount;

        /// <summary>
        /// Time between respawn
        /// </summary>
        int _iRespawnTime;

        /// <summary>
        /// Time of the last respawn
        /// </summary>
        int _iLastRespawnTime;

        /// <summary>
        /// List of Pogobots entity used by the spawner
        /// </summary>
        List<PogobotEntity> _listPogobots;

        /// <summary>
        /// Trigger zone
        /// </summary>
        Rectangle _trigger;

        /// <summary>
        /// Flag set if the trigger gotta be used
        /// </summary>
        bool _bUseTrigger;

        /// <summary>
        /// Flag set when the trigger zone is activated
        /// </summary>
        bool _bTriggerZoneActivated;

        #region Properties
#if !GAME
        public static string EDITOR_TILESET { get { return "enemysheet.xml"; } }
        public static string EDITOR_SPRITE { get { return "enemy_jellyfish_jump"; } }
#endif
        /// <summary>
        /// Create and store a number of Pogobot entity. Must be called only once per level.
        /// </summary>
        public int Count 
        { 
            set 
            { 
                _iCount = value;
                for (int i = 0; i < _iCount; i++)
                {
                    _listPogobots.Add(World.Instance.createBlankPogobot());
                }
            }
        }

        /// <summary>
        /// The time between the spawn of two enemies
        /// </summary>
        public int RespawnTime { set { _iRespawnTime = value; } }

        /// <summary>
        /// Trigger zone which start the spawning
        /// </summary>
        public Rectangle Trigger { set { _trigger = value; } }

        /// <summary>
        /// Flag set if the trigger zone is used
        /// </summary>
        public bool UseTrigger { set { _bUseTrigger = value; } }

        #endregion

            /// <summary>
        /// Default constructor
        /// </summary>
        public SpawnerPogobot()
            : base()
        {
            _listPogobots = new List<PogobotEntity>();
            
        }


        /// <summary>
        /// Activate the entity
        /// </summary>
        public override void activate()
        {
            _iLastRespawnTime = TimeClock.Clock.instance.millisecs - _iRespawnTime;
            if (_bUseTrigger)
                _bTriggerZoneActivated = false;
            else
                _bTriggerZoneActivated = true;

            base.activate();
        }

        public override void deactivate()
        {
            _bActive = false;
        }

        public override void update()
        {
            if (!_bTriggerZoneActivated)
            {
                if (_trigger.Contains((int)World.Instance.PlayerPosition.X, (int)World.Instance.PlayerPosition.Y))
                    _bTriggerZoneActivated = true;
                else
                    return;
            }

            //if it appears in the screen => die
            if (ScreenPosition.X > 0 && ScreenPosition.Y > 0 && ScreenPosition.X < Visu.Instance.ScreenWidth &&
                ScreenPosition.Y < Visu.Instance.ScreenHeight)
                die();

            //check if the respawn time has elapsed
            if (TimeClock.Clock.instance.millisecs >= _iRespawnTime + _iLastRespawnTime)
            {
                //check if there is a non active entity
                for (int i = 0; i < _iCount; i++)
                {
                    if (!_listPogobots[i].Active)
                    {
                        //activate a pogobot
                        //_listPogobots[i].activate(_iIdTextureGround, _iIdSpriteGround, _iIdTextureJump, _iIdSpriteJump, _v2Position);
                        _listPogobots[i].activate(_v2Position);
                        _listPogobots[i].HP = HP;
                        _listPogobots[i].Damages = Damages;
                        _iLastRespawnTime = TimeClock.Clock.instance.millisecs;
                        return;
                    }
                }
            }
        }

        /// <summary>
        /// Kill the entity
        /// </summary>
        public override void die()
        {
            _bActive = false;
        }
    }
}
